//%attributes = {}
// bank_ AccountInMachineFormat (aaC_PankkiTiliN)
// ________________________________________
// 11.08.1993 BD.
// Paranneltu versio.
// Parametrit: Pankkitilin numero selväkielisessä muodossa. 
// Esim. bank_ AccountInMachineFormat ("123456-1234")
// Kutsuva procit: orSUORITUS_PANK
//                         orTEE TAPAHTTIE
//                         aaTilitarkiste
// Muutokset:
// 09.09.1993 Lisätty myös jo valmiissa muo-
// dossa olevan tilin käsittely sekä välilyönnin poisto posti-
// pankilla. Korjattu insert string virheet. BD
//
// 13.6.94 Muutettu postipankin tilinnumeron käsittelyä.
// postipankin sisäinen muutos.
// ________________________________________

C_TEXT:C284($0; $1; $bank_tAccount; $2; $bank_tType)  // Tuleva tilinumero ; Pankkitunnus, mikäli löytyy.
//AK: 2010-02-19: C_STRING(14;$0)  ` Lähtevä tilinumero.
C_LONGINT:C283($bank_lAction; $bank_lDelimiterPos)  // Apumuuttuja, kertoo väliviivan sijainnin.
C_BOOLEAN:C305($fPoistu)
$bank_tAccount:=$1
$bank_tType:=$2
If (Count parameters:C259>=3)
	$bank_lAction:=$3
Else 
	$bank_lAction:=kSet
End if 
$0:=$bank_tAccount

Case of 
	: ($bank_lAction=kGet)  //AK: 2010-02-12
		If ($bank_tType="")
			$bank_tType:=Substring:C12($bank_tAccount; 1; 1)
		End if 
		Case of 
			: ($bank_tType="8")
				$bank_lDelimiterPos:=6
			: (($bank_tType="8") | ($bank_tType="T") | ($bank_tType="P"))  // Postipankki
				$bank_lDelimiterPos:=6
				$bank_tAccount:=Substring:C12(Insert string:C231($bank_tAccount; 6*"8"; 1); 1; 14)  // Saadaan alkuosa mukaan.
			: (($bank_tType="1") | ($bank_tType="2") | ($bank_tType="3") | ($bank_tType="6") | ($bank_tType="9"))  // KOP, SYP, ÅAB, SHB
				$bank_lDelimiterPos:=6
			: (($bank_tType="4") | ($bank_tType="5") | ($bank_tType="7"))  // SKOP, OSUUS, OKO, STS
				$bank_lDelimiterPos:=7
			Else 
				$bank_lDelimiterPos:=0
		End case 
		If ($bank_lDelimiterPos>0)
			$0:=Substring:C12($bank_tAccount; 1; $bank_lDelimiterPos)
			$0:=$0+"-"+_str FirstCharRemove(Substring:C12($bank_tAccount; $bank_lDelimiterPos+1); "0"; kTrue)
		End if 
		
	: ($bank_lAction=kSet)
		$fPoistu:=False:C215
		$0:=14*"0"
		
		If ($bank_tAccount#"")
			
			//AK: 2011-01-10 (v67 -> v12 moved manually)
			If ($bank_tAccount="FI@")  //AK: 2011-01-10: finnish iban?
				$0:=Replace string:C233(Substring:C12($bank_tAccount; 5); ksSpace; "")
			Else 
				
				If (Position:C15("-"; $bank_tAccount)>0)  // Viivan kanssa.
					$bank_lDelimiterPos:=Position:C15("-"; $bank_tAccount)
					$bank_tAccount:=Delete string:C232($bank_tAccount; $bank_lDelimiterPos; 1)
				End if 
				
				If (Length:C16($bank_tAccount)>0)
					Repeat 
						If ((Character code:C91($bank_tAccount[[1]])<48) | (Character code:C91($bank_tAccount[[1]])>57))
							$bank_tAccount:=Delete string:C232($bank_tAccount; 1; 1)  // Poistetaan kirjaimet jne… edestä.  
						Else 
							$fPoistu:=True:C214
						End if 
					Until (($fPoistu) | (Length:C16($bank_tAccount)=0))
				End if 
				
				If ($bank_tType="")
					$bank_tType:=Substring:C12($bank_tAccount; 1; 1)
				End if 
				
				If (($bank_lDelimiterPos>0) | ($bank_tType#""))
					Case of 
						: ($bank_tType="8")
							$bank_lDelimiterPos:=6
						: (($bank_tType="8") | ($bank_tType="T") | ($bank_tType="P"))  // Postipankki
							$bank_lDelimiterPos:=6
							$bank_tAccount:=Substring:C12(Insert string:C231($bank_tAccount; 6*"8"; 1); 1; 14)  // Saadaan alkuosa mukaan.
						: (($bank_tType="1") | ($bank_tType="2") | ($bank_tType="3") | ($bank_tType="6") | ($bank_tType="9"))  // KOP, SYP, ÅAB, SHB
							$bank_lDelimiterPos:=6
						: (($bank_tType="4") | ($bank_tType="5") | ($bank_tType="7"))  // SKOP, OSUUS, OKO, STS
							$bank_lDelimiterPos:=7
					End case 
					
					If ((Length:C16($bank_tAccount)<15) & ($bank_lDelimiterPos>0))
						$0:=Replace string:C233($0; $bank_lDelimiterPos*"0"; Substring:C12($bank_tAccount; 1; $bank_lDelimiterPos); 1)  // alkuosa
						$bank_tAccount:=Delete string:C232($bank_tAccount; 1; $bank_lDelimiterPos)  // Jää vain loppuosa.
						$0:=Delete string:C232($0; Length:C16($0)-Length:C16($bank_tAccount)+1; Length:C16($bank_tAccount))
						$0:=Insert string:C231($0; $bank_tAccount; Length:C16($0)+1)
					Else 
						$0:=$bank_tAccount
					End if 
					
				Else 
					
					If (Length:C16($bank_tAccount)=14)
						$0:=$bank_tAccount
					Else 
						$0:=Replace string:C233($0; 6*"0"; "888888"; 1)  // Jos ei alkuosaa, luultavasti postipankki.
						$0:=Substring:C12(Insert string:C231($0; $bank_tAccount; 15-Length:C16($bank_tAccount)); 1; 14)
					End if 
				End if 
				
			End if 
		End if 
	Else 
		_err MESSAGE_PARAMETER("$3"; Current method name:C684; kFalse)
End case 
